#version 330

uniform sampler2D color0Tex;
uniform sampler2D shadowMap0;
uniform sampler2D shadowMap1;
uniform sampler2D shadowMap2;
uniform sampler2D shadowMap3;
uniform mat4 shadowViewProj[4];
uniform mat4 invPersp;
uniform mat4 invView;
uniform vec4 shadowSize;
uniform vec4 shadowDepthRange;
uniform float farClip;

in vec4 uv;

out vec4 oColor;

#if _PCF
#if 0
const int Samples = 8;
const vec2 disk[8] = vec2[](
	vec2(-0.07900347, 0.5206485), vec2(0.2847629, -0.3450293), vec2(0.6480699, 0.7483952), vec2(-0.2799523, -0.2719631),
	vec2(-0.7749665, 0.3771133), vec2(0.7915559, 0.04572513), vec2(-0.7241086, -0.599465), vec2(-0.04868191, -0.8063754)
);
#else
const int Samples = 9;
const vec2 disk[9] = vec2[](
	vec2(-0.138918, 0.5088004),
	vec2(0.3175047, 0.04867892),
	vec2(-0.02855524, -0.5441281),
	vec2(-0.9169432, -0.1603175),
	vec2(0.7365499, -0.6351371),
	vec2(0.9692433, 0.2428309),
	vec2(-0.6177713, -0.7484137),
	vec2(-0.7447484, 0.4195179),
	vec2(-0.311016, -0.04976188)
);
#endif
#endif
	
vec4 screenToProj(in vec2 iCoord)
{
    return vec4(2.0f * vec2(iCoord.x, 1.0f - iCoord.y) - 1, 0.0, 1.0);
}

vec3 depthToPosition(in float iDepth, in vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

float random(in vec3 seed, in float freq)
{
   float dt = dot(floor(seed * freq), vec3(53.1215, 21.1352, 9.1322));
   return fract(sin(dt) * 2105.2354);
}

float lit(in vec4 posWs, in vec2 offset) {
	vec4 shadowUV0, shadowUV1, shadowUV2, shadowUV3;
	shadowUV0 = shadowViewProj[0] * posWs;
	shadowUV0.xyz = vec3(shadowUV0.xy + offset*(1.0/1.0), shadowUV0.z * 0.5 + 0.5);
	shadowUV1 = shadowViewProj[1] * posWs;
	shadowUV1.xyz = vec3(shadowUV1.xy + offset*(1.0/4.0), shadowUV1.z * 0.5 + 0.5);
	shadowUV2 = shadowViewProj[2] * posWs;
	shadowUV2.xyz = vec3(shadowUV2.xy + offset*(1.0/32.0), shadowUV2.z * 0.5 + 0.5);
	shadowUV3 = shadowViewProj[3] * posWs;
	shadowUV3.xyz = vec3(shadowUV3.xy + offset*(1.0/128.0), shadowUV3.z * 0.5 + 0.5);
	
	vec2 edge0 = vec2(random(posWs.xyz, 64.0)*0.1 + 0.9);
	vec2 edge1 = vec2(random(posWs.xyz, 32.0)*0.1 + 0.9);
	vec2 edge2 = vec2(random(posWs.xyz, 16.0)*0.1 + 0.9);
	
	const float Bias = 2.0 / 65535;
	float d;
	if(all(lessThanEqual(abs(shadowUV0.xy*2 - 1), edge0))) {
		d = textureLod(shadowMap0, shadowUV0.xy, 0).x;
		return (shadowUV0.z - (d + Bias) < 0.0) ? 1.0 : 0.0;
	}
	else if(all(lessThanEqual(abs(shadowUV1.xy*2 - 1), edge1))) {
		d = textureLod(shadowMap1, shadowUV1.xy, 0).x;
		return (shadowUV1.z - (d + Bias*2) < 0.0) ? 1.0 : 0.0;
	}
	else if(all(lessThanEqual(abs(shadowUV2.xy*2 - 1), edge2))) {
		d = textureLod(shadowMap2, shadowUV2.xy, 0).x;
		return (shadowUV2.z - (d + Bias*4) < 0.0) ? 1.0 : 0.0;
	}
	else {
		vec2 fade = abs(shadowUV3.xy*2 - 1)*8.0 - 7.0;
		d = textureLod(shadowMap3, shadowUV3.xy, 0).x;
		return (shadowUV3.z - (d + Bias*16) < 0.0) ? 1.0 : clamp(max(fade.x, fade.y), 0.0, 1.0);
	}
} 

void main()
{
	float depth = textureLod(color0Tex, uv.xy, 0).z;
	
	if(depth == 0) {
		depth = -1.0;
	}
	
	vec4 projSpace = screenToProj(uv.xy);
	vec4 posVs = vec4(depthToPosition(depth, projSpace), 1.0);
	vec4 posWs = invView * posVs;
	
#if PCF

	float l = 0.0;
	l += lit(posWs, shadowSize.zw * vec2(1.0, 0.5));
	l += lit(posWs, shadowSize.zw * vec2(-0.5, 1.0));
	l += lit(posWs, shadowSize.zw * vec2(-1.0, -0.5));
	l += lit(posWs, shadowSize.zw * vec2(0.5, -1.0));
	l *= 0.25;
	
#else
	
	float l = lit(posWs, vec2(0.0));
	
#endif
	
	oColor = vec4(l, l, l, l);
}
